<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
        <div onmouseenter="hideFlash()" id="flash" class="max-w-[80rem] mx-auto sm:px-6 lg:px-8 mb-5 fixed top-10 right-0 left-0 z-100">
            <div class="rounded-xl border border-success-500 bg-green-400 p-4 relative">
                <div class="flex items-start gap-3">
                    <div class="-mt-0.5 text-success-500">
                        <svg class="fill-current text-white" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" > <path fill-rule="evenodd" clip-rule="evenodd" d="M3.70186 12.0001C3.70186 7.41711 7.41711 3.70186 12.0001 3.70186C16.5831 3.70186 20.2984 7.41711 20.2984 12.0001C20.2984 16.5831 16.5831 20.2984 12.0001 20.2984C7.41711 20.2984 3.70186 16.5831 3.70186 12.0001ZM12.0001 1.90186C6.423 1.90186 1.90186 6.423 1.90186 12.0001C1.90186 17.5772 6.423 22.0984 12.0001 22.0984C17.5772 22.0984 22.0984 17.5772 22.0984 12.0001C22.0984 6.423 17.5772 1.90186 12.0001 1.90186ZM15.6197 10.7395C15.9712 10.388 15.9712 9.81819 15.6197 9.46672C15.2683 9.11525 14.6984 9.11525 14.347 9.46672L11.1894 12.6243L9.6533 11.0883C9.30183 10.7368 8.73198 10.7368 8.38051 11.0883C8.02904 11.4397 8.02904 12.0096 8.38051 12.3611L10.553 14.5335C10.7217 14.7023 10.9507 14.7971 11.1894 14.7971C11.428 14.7971 11.657 14.7023 11.8257 14.5335L15.6197 10.7395Z" fill="" /> </svg>
                    </div>

                    <div>
                        <h4 class="mb-1 text-sm font-semibold text-gray-800 dark:text-white/90"> <?php echo e(session('message')); ?> </h4>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="pt-12 pb-3">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="rounded-2xl border border-gray-200 bg-white">
                        <div class="px-6 py-5 grid grid-cols-2">
                            <h3 class="text-base font-medium text-gray-800"> Set Waktu Keluaran </h3>
                            <div class="flex justify-end items-center text-gray-800">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                </svg>
                                <span id="time-now" class="font-md mx-1"></span>
                            </div>
                        </div>
                        <div class="border-t border-gray-100 px-5 py-5">
                                <div class="grid lg:grid-cols-6 grid-cols-1 gap-4">
                                    <div class="lg:col-span-3 col-span-1">
                                        <input
                                        name="timerEnd"
                                        type="datetime-local"
                                        class="shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full appearance-none rounded-lg border border-gray-300 bg-transparent bg-none px-4 py-2.5 pr-11 pl-4 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden"
                                        wire:model="timerEnd"
                                        />
                                    </div>
                                    <button type="button" name="submit" wire:click="setTimer()" class="inline-flex items-center gap-2 px-4 py-3 text-sm font-medium text-white transition rounded-lg bg-blue-700 shadow-theme-xs hover:bg-blue-600 justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.347a1.125 1.125 0 0 1 0 1.972l-11.54 6.347a1.125 1.125 0 0 1-1.667-.986V5.653Z" />
                                        </svg>
                                        Set Timer
                                    </button>
                                    <div class="rounded-lg border border-gray-200 flex justify-center items-center lg:col-span-2 col-span-1 px-4 py-2.5 pr-11 pl-4 bg-gray-200">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5 text-gray-600 mr-1">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                        </svg>
                                        <p class="text-gray-600"><?php echo e($miscdata->timer_end); ?></p>
                                    </div>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['timerEnd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="mt-1 block"> <p class="text-red-500 text-xs"><?php echo e($message); ?></p> </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="pt-3 pb-3">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-4 lg:gap-4">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $fourdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="px-4 py-2 lg:px-0 lg:py-0">
                        <div class="rounded-2xl border border-gray-200 bg-white p-5 md:p-6 w-[100%] hover:bg-gray-200">
                            <div class="grid grid-cols-3 gap-2">
                                <div class="col-span-2">
                                    <p class="text-gray-700 text-sm mb-3">
                                        <?php echo e(Str::substr($item->day, 0, 3)); ?>,
                                        <?php echo e(\Carbon\Carbon::parse($item->date)->format('j-m-Y')); ?>

                                    </p>
                                    <h2 class="text-gray-700 text-2xl font-medium"><?php echo e($item->p_1st); ?></h2>
                                </div>
                                <div class="col-span-1 flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-8 text-gray-700">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    </div>

    <div class="pt-3 pb-3">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 mb-20">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="rounded-2xl border border-gray-200 bg-white">
                        <div class="px-6 py-5">
                            <h3 class="text-base font-medium text-gray-800"> Tambah Keluaran </h3>
                        </div>
                        <div class="border-t border-gray-100 px-5 py-5">
                            <div>
                                <h3 class="text-sm mb-3">Tanggal</h3>
                                <div>
                                    <input
                                    name="dateNumbers"
                                    type="date"
                                    wire:model="dateNumbers"
                                    class="shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full appearance-none rounded-lg border border-gray-300 bg-transparent bg-none px-4 py-2.5 pr-11 pl-4 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden col-span-1"
                                    />
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['dateNumbers'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="mt-1 block"> <p class="text-red-500 text-xs"><?php echo e($message); ?></p> </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <div class="mt-4">
                                <h3 class="text-sm mb-3">Main Prize</h3>
                                <div class="grid grid-cols-6 gap-4">
                                    <div class="lg:col-span-5 col-span-4">
                                        <input
                                        name="numbers"
                                        type="text"
                                        placeholder="Main Prize"
                                        value="<?php echo e($numbers); ?>"
                                        wire:model="numbers"
                                        class="main-prz shadow-theme-xs focus:border-brand-300 focus:ring-brand-500/10 dark:focus:border-brand-800 h-11 w-full appearance-none rounded-lg border border-gray-300 bg-transparent bg-none px-4 py-2.5 pr-11 pl-4 text-sm text-gray-800 placeholder:text-gray-400 focus:ring-3 focus:outline-hidden"
                                        />
                                    </div>
                                    <button
                                    wire:click="generate4d"
                                    class="inline-flex items-center gap-2 px-4 py-3 text-sm font-medium text-white transition rounded-lg bg-blue-700 shadow-theme-xs hover:bg-blue-600 justify-center lg:col-span-1 col-span-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99" />
                                        </svg>
                                    </button>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['numbers'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="mt-1 block"> <p class="text-red-500 text-xs"><?php echo e($message); ?></p> </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="mt-6">
                                    <button
                                    type="button"
                                    name="submit"
                                    wire:click="insertNumber()"
                                    class="inline-flex items-center gap-2 px-4 py-3 text-sm font-medium text-white transition rounded-lg bg-green-800 shadow-theme-xs hover:bg-green-600 justify-center w-[100%]">
                                    Simpan Keluaran
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    window.onload = function () { startTime(); }
</script>
<?php /**PATH D:\DESKTOP\breeze\resources\views/livewire/backend/keluaran.blade.php ENDPATH**/ ?>