<div>
    <section id="timer" class="bg-[url('../img/bg-top.png')] bg-center bg-no-repeat bg-cover lg:py-[50px]">
        <div class="mx-auto max-w-[1050px]">
            <div class="min-h-[340px] flex justify-center items-center">
                <div>
                    <ul id="animateNum" class="flex justify-center space-x-8 font-bold lg:text-5xl text-4xl text-color-color4 pb-[25px]">
                        <li id="pools-1" class="drawing lg:w-[60px] lg:h-[60px] w-[50px] h-[50px] p-1 bg-color-color2 rounded-md flex justify-center items-center">-</li>
                        <li id="pools-2" class="drawing lg:w-[60px] lg:h-[60px] w-[50px] h-[50px] p-1 bg-color-color2 rounded-md flex justify-center items-center">-</li>
                        <li id="pools-3" class="drawing lg:w-[60px] lg:h-[60px] w-[50px] h-[50px] p-1 bg-color-color2 rounded-md flex justify-center items-center">-</li>
                        <li id="pools-4" class="drawing lg:w-[60px] lg:h-[60px] w-[50px] h-[50px] p-1 bg-color-color2 rounded-md flex justify-center items-center">-</li>
                    </ul>
                    <div class="text-center">
                        <h3 class="text-xl text-color-color4 font-sans font-extralight">Next Draw In</h3>
                        <div class="space-x-3 my-1">
                            <span id="hours" class="text-color-color5 lg:text-5xl text-4xl">--</span>
                            <span class="text-color-color5 lg:text-5xl text-4xl">:</span>
                            <span id="minutes" class="text-color-color5 lg:text-5xl text-4xl">--</span>
                            <span class="text-color-color5 lg:text-5xl text-4xl">:</span>
                            <span id="seconds" class="text-color-color5 lg:text-5xl text-4xl">--</span>
                        </div>
                        <h3 id="drawDate" class="text-md text-color-color4 font-sans font-extralight">Everyday at 09:30 UTC -3</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="lastResults">
        <div class="bg-color-color3 relative bg-[url('../img/splash.png')] bg-center bg-no-repeat bg-cover">
            <img class="lg:block hidden absolute left-0 top-0 w-[260px]" src="{{ asset('assets/img/leafs-1.png') }}" alt="Leafs">
            <img class="lg:block hidden absolute right-0 bottom-0 w-[235px]" src="{{ asset('assets/img/leafs-2.png') }}" alt="Leafs">
            <div class="mx-auto max-w-[1000px]">
                <div class="lg:py-12 px-3 py-7">
                    <div class="min-h-[300px] bg-color-color1 rounded-2xl lg:py-10 lg:px-8 px-5 py-10 lg:z-[100] lg:relative">
                        <div class="grid lg:grid-cols-4 grid-cols-1">
                            <h2 class="font-joti text-color-color4 text-2xl col-span-3 flex items-center lg:justify-start justify-center lg:mb-0 mb-5">Latest Results</h2>
                            <a href="/results" class="text-color-color4 text-lg bg-color-color2 text-center rounded-full px-2 py-2 w-full">All Results</a>
                        </div>
                        <div class="mt-5">
                            <div id="lastId" class="grid lg:grid-cols-3 grid-cols-2 border-b-[1px] border-color-color2 py-4 px-3 last:border-b-0">
                                <div class="lg:col-span-2 text-color-color4 lg:text-lg text-sm flex items-center">
                                {{ Str::substr($lastid->day, 0, 3) }},
                                {{ \Carbon\Carbon::parse($lastid->date)->format('j-m-Y') }}
                                </div>
                                <div class="text-color-color4 text-xl flex justify-end lg:gap-6 gap-3">
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($lastid->p_1st, 0, 1) }}</span>
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($lastid->p_1st, 1, 1) }}</span>
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($lastid->p_1st, 2, 1) }}</span>
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($lastid->p_1st, 3, 1) }}</span>
                                </div>
                            </div>
                            @foreach ($dataResults as $result)
                            <div class="grid lg:grid-cols-3 grid-cols-2 border-b-[1px] border-color-color2 py-4 px-3 last:border-b-0">
                                <div class="lg:col-span-2 text-color-color4 lg:text-lg text-sm flex items-center">
                                {{ Str::substr($result->day, 0, 3) }},
                                {{ \Carbon\Carbon::parse($result->date)->format('j-m-Y') }}
                                </div>
                                <div class="text-color-color4 text-xl flex justify-end lg:gap-6 gap-3">
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($result->p_1st, 0, 1) }}</span>
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($result->p_1st, 1, 1) }}</span>
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($result->p_1st, 2, 1) }}</span>
                                    <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md">{{ Str::substr($result->p_1st, 3, 1) }}</span>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    @php
    $endTime = strtotime($miscdata->timer_end);
    $end = date('M d, Y H:i:s', $endTime);
    @endphp

    <script>
        const drawing = document.querySelectorAll(".drawing");
        const drawDate = document.getElementById("drawDate");
        const animateNum = document.getElementById("animateNum");
        const lastId = document.getElementById("lastId");
        const loader = '<img src="{{ asset('assets/img/loader.svg') }}" alt="loader">';
        const p1_1 = document.getElementById("pools-1");
        const p1_2 = document.getElementById("pools-2");
        const p1_3 = document.getElementById("pools-3");
        const p1_4 = document.getElementById("pools-4");

        var countDownDate = new Date('{{ $end }}').getTime();
        const h = document.getElementById("hours");
        const m = document.getElementById("minutes");
        const s = document.getElementById("seconds");
        
        var x = setInterval( function() {

            var now = new Date().getTime();
            var distance = countDownDate - now;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            h.innerHTML = hours < 10 ? '0' + hours : hours;
            m.innerHTML = minutes < 10 ? '0' + minutes : minutes;
            s.innerHTML = seconds < 10 ? '0' + seconds : seconds;


            if (distance <= 300000) {
                var reload = setInterval(() => {
                    window.location.reload();
                }, 10000);

                drawing.forEach( y => {
                    y.innerHTML = "-";
                });
                drawDate.innerHTML = "Drawing on prepare..";
                lastId.classList.replace("grid", "hidden");
            }

            if (distance <= 290000) {
                clearInterval(reload);
            }
            
            if (distance < 0) {
                h.innerHTML = "00";
                m.innerHTML = "00";
                s.innerHTML = "00";
                drawDate.innerHTML = "{{ $lastid->day }}, {{ \Carbon\Carbon::parse($lastid->date)->format('j-m-Y') }}";
                drawing.forEach(item => { item.innerHTML = loader; });
            }

            if (distance < -5000){
                p1_4.innerHTML = '<?=substr($lastid->p_1st ,3,1)?>';
            }
            if (distance < -10000){
                p1_3.innerHTML = '<?=substr($lastid->p_1st ,2,1)?>';
            }
            if (distance < -15000){
                p1_2.innerHTML = '<?=substr($lastid->p_1st ,1,1)?>';
            }
            if (distance < -20000){
                p1_1.innerHTML = '<?=substr($lastid->p_1st ,0,1)?>';
                lastId.classList.replace("hidden", "grid");
            }

        }, 1000);

        var now = new Date().getTime(); var distance = countDownDate - now; var days = Math.floor(distance / (1000 * 60 * 60 * 24)); var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)); var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60)); var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        // After drawing
        if (distance > 300000) {
            window.onload = function () { animate();}  
        }

        function animate() {

            const pools1 = setInterval(function() {
                var t = Math.round(Math.random() * (9 - 1) + 1);
                document.getElementById("pools-1").innerHTML = t;
            }, 80);

            const pools2 = setInterval(function() {
                var t = Math.round(Math.random() * (9 - 1) + 1);
                document.getElementById("pools-2").innerHTML = t;
            }, 80);

            const pools3 = setInterval(function() {
                var t = Math.round(Math.random() * (9 - 1) + 1);
                document.getElementById("pools-3").innerHTML = t;
            }, 80);

            const pools4 = setInterval(function() {
                var t = Math.round(Math.random() * (9 - 1) + 1);
                document.getElementById("pools-4").innerHTML = t;
            }, 80);

            if (distance <= 300000) {
                clearInterval(pools1); clearInterval(pools2); clearInterval(pools3); clearInterval(pools4);
            }
        }
        


    </script>
</div>